//
//  MCReportTableAbstractRow.h
//  Composer
//
//  Created by Alykhan Jetha on 23/07/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import "MCReportRegion.h"

@class MCReportTable;
@class MCReportTextArea;

@interface MCReportTableAbstractRow : MCReportRegion {
	float indentValue;
	MCReportElement *cellToCopy;
}

- (MCReportTable *)enclosingReportTable;

- (unsigned int)tableLayoutPriority;

- (NSArray *)xSortedSubviews;
- (NSArray *)xSortedSelectedViews;
- (MCReportElement *)leftMostCell;

- (MCReportElement *)cellToCopy;
- (void)setCellToCopy:(MCReportElement *)aCellToCopy;

- (float)indentValue;
- (void)setIndentValue:(float)anIndentValue;

- (void)adjustLeftMostCellForIndentValue;

- (IBAction)addColumnToRight:(id)sender;
- (IBAction)addColumnToLeft:(id)sender;

- (MCReportElement *)addCellOfClassname:(NSString *)aClassname template:(MCReportElement *)aTemplate label:(NSString *)aLabel keypath:(NSString *)aKeypath formatter:(NSFormatter *)aFormatter alignment:(NSTextAlignment)alignment width:(float)aWidth;

- (MCReportElement *)addCellOfClassname:(NSString *)aClassname 
							   template:(MCReportElement *)aTemplate 
								  label:(NSString *)aLabel 
								keypath:(NSString *)aKeypath
							  formatter:(NSFormatter *)aFormatter
						  formatterCode:(int)aFormatterCode 
							  alignment:(NSTextAlignment)alignment 
								  width:(float)aWidth;


// adds a cell of call CellClass in the right position. The caller should further customize the element
- (MCReportElement *)addCellUsingClass:(Class)CellClass width:(float)aWidth;

// add TextArea's - does not resize, does not tell other row, you must ensure the width is correct for all the ones you are going to add
- (MCReportElement *)addCellWithLabel:(NSString *)aLabel keypath:(NSString *)aKeypath width:(float)aWidth;

- (void)otherRow:(MCReportTableAbstractRow *)aRow willAddCellAdjacentToCellAtIndex:(int)anIndex;
- (void)otherRow:(MCReportTableAbstractRow *)aRow didAddCell:(MCReportElement *)element suggestedInsertionPoint:(NSPoint)insertPoint;
- (void)otherRow:(MCReportTableAbstractRow *)aRow didResizeCell:(MCReportElement *)element;
- (void)otherRow:(MCReportTableAbstractRow *)aRow didDeleteCell:(MCReportElement *)element;

- (void)sizeAndPositionCellToMatchOtherRowCells:(NSArray *)otherCells;

- (void)sizeCellsToMatchMaxRowHeight:(float)aHeight;
- (void)sizeToMaxHeightOfSubviews;

- (NSString *)newTextCellText;
- (BOOL)newTextCellShouldBeDynamic;

- (MCReportTextArea *)firstTextArea;
@end
